from machine import Pin, I2C, freq
from ssd1306 import SSD1306_I2C
from steptime import STEPTIME
import time
import math
import urandom

freq(250_000_000)

# --- OLED ---
i2c = I2C(1, sda=Pin(6), scl=Pin(7), freq=200000)
oled = SSD1306_I2C(128, 64, i2c, addr=0x3C)

# --- Touch pads ---
PINS = [26, 27, 1, 2, 3, 4]
for p in PINS:
    Pin(p, Pin.IN, Pin.PULL_UP)

channels = [[STEPTIME(i, pin), [1e6]] for i, pin in enumerate(PINS)]

loop = 200
settle = 20000
thresh = 12000  # adjust if needed

def read_touch():
    states = []
    for sm, minv in channels:
        sm.put(loop)
        sm.put(settle)
        r = 4294967296 - sm.get()
        if r < minv[0]:
            minv[0] = r
        states.append((r - minv[0]) > thresh)
    return states

# Warmup baseline
t0 = time.ticks_ms()
while time.ticks_diff(time.ticks_ms(), t0) < 800:
    read_touch()
    time.sleep_ms(20)

speed = 0.15
freq_val = 0.08
phase = 0
frozen = False
prev_freeze = False
rand_flash = 0   # brief visual indicator

prev_freeze = False 

while True:
    touch = read_touch()

    # Controls
    if touch[0]: speed += 0.01
    if touch[1]: speed -= 0.01
    if touch[2]: freq_val += 0.005
    if touch[3]: freq_val -= 0.005
    if touch[4]:
        phase = urandom.getrandbits(16)
        rand_flash = 5   # show indicator for a few frames
    if touch[5] and not prev_freeze:
        frozen = not frozen
    prev_freeze = touch[5]

    speed = max(0.01, min(speed, 0.5))
    freq_val = max(0.01, min(freq_val, 0.2))

    if not frozen:
        phase += speed

    oled.fill(0)
    # Clear top band
    oled.fill_rect(0, 0, 128, 16, 0)

    # Line 1: speed + frequency
    oled.text("SPD:%0.2f" % speed, 0, 0, 1)
    oled.text("F:%0.3f" % freq_val, 70, 0, 1)

    # Line 2: frozen + random indicator
    if frozen:
        oled.text("FREEZE", 0, 8, 1)

    if rand_flash > 0:
        oled.text("RAND!", 70, 8, 1)
        rand_flash -= 1

    for x in range(128):
        for y in range(16, 64):
            v = math.sin(x * freq_val + phase) + math.sin(y * freq_val + phase)
            oled.pixel(x, y, 1 if v > 0 else 0)

    oled.show()
    time.sleep_ms(20)
