# main.py: Game selection menu by Vincent Mistler (YouMakeTech)
from machine import Pin, PWM, I2C, Timer
from ssd1306 import SSD1306_I2C
import time
import random
from steptime import STEPTIME
from button import Button

if __name__ == "__main__":
    # To avoid strange errors at startup
    # I don't know why but it works!
    time.sleep(0.2)
    
    # size of the screen
    SCREEN_WIDTH=128                       
    SCREEN_HEIGHT=64
    
    # list of games
    GAMELIST=["Pong","Snake","Space Invaders", "Dino", "2048", "Tetris","Full Speed","Lunar Module"]

    # OLED Screen connected to GP6 (SDA) and GP7 (SCL)
    i2c = I2C(1, scl=Pin(7), sda=Pin(6), freq=200000)
    oled = SSD1306_I2C(128, 64, i2c)

    current = 0
    game_selected = -1

    # Configure left side buttons
    #   x    [26]
    # x   x  [27, 1]
    #   x    [2]
    up = Button('up', 26, 0) # Button args: type, pin_num, state_machine_id
    right = Button('right', 1, 1)
    down = Button('down', 2, 2)
    left = Button('left', 27, 3)

    # Configure right side buttons
    #    x   [4]
    #  x     [3]
    button1 = Button('button1', 4, 4)
    button2 = Button('button2', 3, 5)

    while True:
        oled.fill(0)
        for row in range(0, len(GAMELIST)):
            if row == current:
                oled.fill_rect(0, row*8, SCREEN_WIDTH, 7, 1)
                color = 0
            else:
                color = 1
            
            oled.text(GAMELIST[row], int(SCREEN_WIDTH/2)-int(len(GAMELIST[row])/2 * 8), row*8,color)
        
        oled.show()
        
        time.sleep(0.2)

        buttonPressed = False
        while not buttonPressed:
            if (down.value() == 0 or right.value() == 0) and current < len(GAMELIST) - 1:
                current += 1
                buttonPressed = True
            elif (up.value() == 0 or left.value() == 0) and current > 0:
                current -= 1
                buttonPressed = True
            elif button1.value()==0 or button2.value()==0:
                buttonPressed = True
                game_selected = current

        # Start the selected game
        if game_selected >= 0:
            oled.fill(0)
            oled.show()
            
            if game_selected==0:
                from PicoPong import *
                pico_pong_main()
            elif game_selected==1:
                from PicoSnake import *
                pico_snake_main()
            elif game_selected==2:
                from PicoInvaders import *
                pico_invaders_main()
            elif game_selected==3:
                from PicoDino import *
                pico_dino_main()
            elif game_selected==4:
                from Pico2048 import *
                pico_2048_main()
            elif game_selected==5:
                from PicoTetris import *
                pico_tetris_main()
            elif game_selected==6:
                from PicoFullSpeed import *
                pico_full_speed_main()
            elif game_selected==7:
                from PicoLunarModule import *
                pico_lunar_module_main()
                
        game_selected=-1


