#
# button.py
#
# This work may be reproduced, modified, distributed,
# performed, and displayed for any purpose, but must
# acknowledge this project. Copyright is retained and
# must be preserved. The work is provided as is; no
# warranty is provided, and users accept all liability.
#
# install MicroPython
#    https://micropython.org/download/RPI_PICO/
#

from machine import Pin
from steptime import STEPTIME

LOOP = 200
SETTLE = 20000
THRESH = 10000

class Button:
    def __init__(self, btnType, pin, sm_id):
        self.type = btnType
        self.pin = Pin(pin, Pin.IN, Pin.PULL_UP)

        self.min_val = 1e6
        self.btnPressed = ''
        self.sm = STEPTIME(sm_id, pin)


    def value(self):
        sm = self.sm
        val = self.type

        sm.put(LOOP)
        sm.put(SETTLE)
        result = 4294967296 - sm.get()

        if result < self.min_val: # No button is being pressed
            self.min_val = result

        if result - self.min_val > THRESH: # Button is pressed
            if self.btnPressed != val: # Not a long press
                self.btnPressed = val
                return False
        else:
            self.btnPressed = ''

        return True
