// Constantes para los pines
const int PIN_POT_R = D0;    // Potenciómetro Rojo (entrada ADC)
const int PIN_POT_G = D1;    // Potenciómetro Verde (entrada ADC)
const int PIN_POT_B = D2;    // Potenciómetro Azul (entrada ADC)

const int PIN_LED_R = D10;   // LED Rojo (salida PWM)
const int PIN_LED_G = D9;    // LED Verde (salida PWM)
const int PIN_LED_B = D8;    // LED Azul (salida PWM)

// Constantes para rangos
const int ADC_MAX = 4095;     // ESP32: ADC de 12 bits (0-4095)
const int PWM_MAX = 255;      // PWM de 8 bits (0-255)

void setup() {
  // Configurar pines de potenciómetros como entradas
  pinMode(PIN_POT_R, INPUT);
  pinMode(PIN_POT_G, INPUT);
  pinMode(PIN_POT_B, INPUT);
  
  // Configurar pines de LEDs como salidas
  pinMode(PIN_LED_R, OUTPUT);
  pinMode(PIN_LED_G, OUTPUT);
  pinMode(PIN_LED_B, OUTPUT);
  
  // Para mejor resolución, puedes usar PWM de 12 bits:
  // analogWriteResolution(12);
  // Y entonces PWM_MAX sería 4095
}

void loop() {
  // Leer potenciómetros (0-4095) y mapear a PWM (0-255) directamente
  analogWrite(PIN_LED_R, map(analogRead(PIN_POT_R), 0, ADC_MAX, 0, PWM_MAX));
  analogWrite(PIN_LED_G, map(analogRead(PIN_POT_G), 0, ADC_MAX, 0, PWM_MAX));
  analogWrite(PIN_LED_B, map(analogRead(PIN_POT_B), 0, ADC_MAX, 0, PWM_MAX));
  
  // Pequeña pausa para estabilidad
  delay(10);
}