#include <Wire.h> 
#include <EEPROM.h>
#include "LiquidCrystal_I2C.h"

#define BUZZER 21   
#define BUTTON 20   
#define LED1   8    
#define LED2   9    
#define LED3   10   

#define EEPROM_SIZE 64
const int RECORD_ADDR = 0; 

// We will try to talk to the LCD at 0x27
LiquidCrystal_I2C lcd(0x27, 16, 2); 

void setup() {
  Serial.begin(115200);
  while(!Serial); // Wait for Serial Monitor to open
  Serial.println("\n--- DEBUG START ---");

  // 1. Test I2C Connection
  Wire.begin(6, 7);
  Wire.beginTransmission(0x27);
  if (Wire.endTransmission() == 0) {
    Serial.println("SUCCESS: LCD found at 0x27");
  } else {
    Serial.println("ERROR: No LCD found at 0x27. Checking 0x3F...");
    Wire.beginTransmission(0x3F);
    if (Wire.endTransmission() == 0) {
      Serial.println("SUCCESS: LCD found at 0x3F instead!");
    } else {
      Serial.println("FATAL ERROR: No LCD detected at all. Check wires!");
    }
  }

  // 2. Init EEPROM
  if (!EEPROM.begin(EEPROM_SIZE)) {
    Serial.println("EEPROM Failed!");
  } else {
    Serial.println("EEPROM Ready.");
  }

  pinMode(BUZZER, OUTPUT);
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(LED3, OUTPUT);
  pinMode(BUTTON, INPUT_PULLUP);

  lcd.begin();
  lcd.backlight();
  lcd.print("Check Serial");

  Serial.println("Waiting for Button Press on D7...");
}

void loop() {
  // Check button status
  if (digitalRead(BUTTON) == LOW) {
    Serial.println("Button Pressed! Starting Game...");
    runGame();
  }
  delay(100); // Small delay to keep the ESP32 cool
}

void runGame() {
  Serial.println("Status: READY...");
  lcd.clear();
  lcd.print("READY...");
  
  for(int i=0; i < 3; i++) {     
    digitalWrite(8+i, HIGH); // D8, D9, D10
    tone(BUZZER, 245, 200);
    delay(1000);
    digitalWrite(8+i, LOW);
  }

  int wait = random(1000, 4000);
  Serial.print("Waiting for: "); Serial.print(wait); Serial.println("ms");
  delay(wait);

  Serial.println("GO! GO! GO!");
  digitalWrite(LED1, HIGH);
  digitalWrite(LED2, HIGH);
  digitalWrite(LED3, HIGH);
  
  unsigned long start = millis();
  while(digitalRead(BUTTON) == HIGH) { yield(); }
  unsigned long reactionTime = millis() - start;

  Serial.print("Reaction Time: "); Serial.print(reactionTime); Serial.println("ms");
  
  lcd.clear();
  lcd.print("Time: "); lcd.print(reactionTime);
  
  delay(3000);
  digitalWrite(LED1, LOW);
  digitalWrite(LED2, LOW);
  digitalWrite(LED3, LOW);
  Serial.println("Game Over. Waiting for next press...");
}