/*
  PROJECT: Goal Sentinel - Prototype v1
  TARGET: ESP32-S3
  ENVIRONMENT: Wokwi Simulator
  AUTHOR: Javier Vega
*/

// --- PIN DEFINITIONS ---
// We use GPIO pins compatible with ESP32-S3
const int SENSOR_PIN = 4;   // Pushbutton simulating ball impact
const int ALERT_PIN = 10;   // LED simulating the goal alarm

void setup() {
  // 1. Initialize Serial Communication (Baud rate 115200 for ESP32)
  Serial.begin(115200);
  
  // 2. Welcome Message
  Serial.println("--- GOAL SENTINEL SYSTEM INITIALIZED ---");
  Serial.println("STATUS: STANDBY. Waiting for impact...");

  // 3. Pin Configuration

  pinMode(SENSOR_PIN, INPUT_PULLUP);
  pinMode(ALERT_PIN, OUTPUT);
}

void loop() {
  // Read the sensor state (Active LOW)
  int sensorState = digitalRead(SENSOR_PIN);

  if (sensorState == LOW) {
    // --- GOAL DETECTED SEQUENCE ---
    
    // A. Local Output (Visual Alarm)
    digitalWrite(ALERT_PIN, HIGH); // Turn LED ON
    
    // B. Remote Output (Data Transmission)
    Serial.println("\n[!] GOAL DETECTED!");
    Serial.println(">>> Impact Velocity: 88 km/h (Simulated)");
    Serial.println(">>> Sending data to cloud...");
    
    // Hold the alarm state for 1 second (1000 ms)
    delay(1000); 
    
    // C. System Reset
    digitalWrite(ALERT_PIN, LOW);  // Turn LED OFF
    Serial.println("--- System Reset. Ready for next shot. ---");
  }
}