# FFMPEG

## Links

https://www.ffmpeg.org/download.html

## Recipes

```bash
ffmpeg -i input.mp4 -vf "scale=-2:720" -c:v libx264 -preset slow -crf 30 -pix_fmt yuv420p -movflags +faststart -an output_new.mp4
```

## Parameters

| Parameter | What it controls | Common options / ranges | Notes / tips |
| --- | --- | --- | --- |
| **`-i input.mp4`** | **Input file** | **any file** | **Always the first “main” argument.** |
| `-c:v libx264` | Video codec (H.264) | `libx264` | Best compatibility (most players/websites). |
| `-c:v libx265` | Video codec (H.265/HEVC) | `libx265` | Usually smaller files, but less universal playback. |
| `-c:a aac` | Audio codec | `aac` | Most compatible audio for MP4. |
| `-preset X` | Encoding speed vs compression | `ultrafast, veryfast, faster, medium, slow, veryslow` | Slower preset = smaller file at same quality, but takes longer. |
| **`-crf N`** | **Quality-based compression (constant quality)** | **H.264: 18–32 (start 28) H.265: 20–34 (start 28–30)** | **Lower = better quality/bigger file. Higher = smaller file.** |
| **`-b:v 800k`** | **Target average video bitrate** | **300k–5000k (depends on res/content)** | **More predictable filesize than CRF. Lower bitrate = smaller file.** |
| `-maxrate 800k` | Peak video bitrate cap | usually same as `-b:v` or slightly higher | Helps keep bitrate steady for streaming/size control. |
| `-bufsize 1600k` | Rate control buffer | often `2× maxrate` | Common rule: `bufsize ≈ 2× maxrate`. |
| `-b:a 96k` | Audio bitrate | 64k (speech), 96k–128k (general) | Easy size savings: reduce audio bitrate. |
| `-an` | Remove audio | (flag) | Biggest cut if audio isn’t needed. |
| **`-vf "scale=-2:720"`** | **Video filter (scaling, etc.)** | **`scale=-2:1080/720/480`** | **`-2` preserves aspect ratio and keeps dimensions valid for codecs.** |
| `-r 30` | Output framerate | 60 / 30 / 24 | Lower fps can reduce size (good for screen recordings). |
| `-movflags +faststart` | Web playback optimization | `+faststart` | Moves MP4 metadata to front (faster start when streaming). |
| `-pix_fmt yuv420p` | Pixel format (compatibility) | `yuv420p` | Use when playback issues occur; best compatibility. |
| `-map 0:v:0` | Select video stream | `0:v:0` | Useful when files have multiple streams. |
| `-map 0:a:0?` | Select audio stream (optional) | `0:a:0?` | `?` means “if audio exists, include it; otherwise don’t error.” |
| `-c:v copy` | Copy video (no re-encode) | `copy` | Super fast, no quality loss—**but won’t reduce video size** unless you change container only. |
| `-c:a copy` | Copy audio (no re-encode) | `copy` | Same idea for audio. |
| `-t 10` | Duration limit | seconds | Useful for trimming quick demos. |
| `-ss 00:00:05` | Start time (seek) | timestamp | Put **before `-i`** for fastest seeking. |
| `-to 00:00:20` | End time | timestamp | Alternative to `-t`. |
| `-pass 1 / -pass 2` | 2-pass encoding (bitrate) | `-pass 1` then `-pass 2` | Best when you must hit a size; more steps. |
| `-y` | Overwrite output | (flag) | Avoids “File exists, overwrite?” prompt. |
| `-hide_banner` | Cleaner output | (flag) | Makes logs less noisy. |

This parameters interfere with each other so dont use them together

### 1) `crf` ↔ `b:v`

- Pick **one main strategy**:
    - **CRF** = constant quality (size varies)
    - **Bitrate** = predictable size (quality varies)

### 2) `crf` ↔ `qp` / `q:v` (constant quantizer modes)

- `qp` (x264/x265 constant QP) and `q:v` (older quality scale for some encoders) are **different quality-control modes**.
- Don’t mix them with `crf`. Pick one.

### 3) `b:v` ↔ `qp` / `q:v`

- Same idea: bitrate mode vs constant-quantizer mode. Pick one.

### 4) `crf` with **bitrate caps** (`maxrate`, `bufsize`)

- This is not “wrong,” but it **changes behavior**:
    - `crf` tries to keep quality
    - `maxrate/-bufsize` can **force quality to drop** to respect the cap
- So think of `maxrate` as a **ceiling** when using CRF.

### 5) `pass 1 / -pass 2` ↔ `crf`

- 2-pass is mainly for hitting a **target bitrate/size**.
- Using CRF in 2-pass is usually pointless/confusing. Use **2-pass + `b:v`**.