from machine import Pin, time_pulse_us
import time

# Pines del sensor
TRIG = Pin(19, Pin.OUT)
ECHO = Pin(18, Pin.IN)

# LEDs
led1 = Pin(17, Pin.OUT)
led2 = Pin(16, Pin.OUT)
led3 = Pin(4, Pin.OUT)
led4 = Pin(0, Pin.OUT)

def medir_distancia():
    TRIG.value(0)
    time.sleep_us(2)

    TRIG.value(1)
    time.sleep_us(10)
    TRIG.value(0)

    duracion = time_pulse_us(ECHO, 1, 40000)
    if duracion < 0:
        return 0

    distancia = (duracion * 0.034) / 2
    return distancia

while True:
    distancia = medir_distancia()
    print("Distance:", distancia, "cm")

    if 0 <= distancia < 100:
        led1.on()
        led2.off()
        led3.off()
        led4.off()

    elif 100 <= distancia < 200:
        led1.off()
        led2.on()
        led3.off()
        led4.off()

    elif 200 <= distancia < 300:
        led1.off()
        led2.off()
        led3.on()
        led4.off()

    else:
        led1.off()
        led2.off()
        led3.off()
        led4.on()

    time.sleep(0.3)