int TRIGPin = 19;
int ECHOPin = 18;
int led1 = 17;
int led2 = 16;
int led3 = 4;
int led4 = 0;

void setup() {
  Serial.begin(115200);

  pinMode(TRIGPin, OUTPUT);
  pinMode(ECHOPin, INPUT);

  pinMode(led1, OUTPUT);
  pinMode(led2, OUTPUT);
  pinMode(led3, OUTPUT);
  pinMode(led4, OUTPUT);
}

void loop() {
  long duration;        // variable declaration
  float distance;       // variable declaration

  // Trigger pulse (clean signal)
  digitalWrite(TRIGPin, LOW); 
  delayMicroseconds(2); // pause before sending the pulse

  // Send trigger pulse
  digitalWrite(TRIGPin, HIGH); 
  delayMicroseconds(10); // pulse duration
  digitalWrite(TRIGPin, LOW);  // stop sending pulse

  duration = pulseIn(ECHOPin, HIGH, 40000); // read echo pulse
  distance = duration * 0.034 / 2;          // distance calculation

  Serial.print("Distance: ");   // screen output
  Serial.print(distance);       // print distance value
  Serial.println(" cm");        // units

  if (distance >= 0 && distance < 100) {
    digitalWrite(led1, HIGH);
    digitalWrite(led2, LOW);
    digitalWrite(led3, LOW);
    digitalWrite(led4, LOW);
  }
  else if (distance >= 100 && distance < 200) {
    digitalWrite(led1, LOW);
    digitalWrite(led2, HIGH);
    digitalWrite(led3, LOW);
    digitalWrite(led4, LOW);
  }
  else if (distance >= 200 && distance < 300) {
    digitalWrite(led1, LOW);
    digitalWrite(led2, LOW);
    digitalWrite(led3, HIGH);
    digitalWrite(led4, LOW);
  }
  else {
    digitalWrite(led1, LOW);
    digitalWrite(led2, LOW);
    digitalWrite(led3, LOW);
    digitalWrite(led4, HIGH);
  }

  delay(300); // waiting time
}