from machine import Pin, ADC, PWM
import time

FWD_PIN  = 27
BWD_PIN  = 26
STOP_PIN = 22

POT_PIN  = 28  # ADC2 (GP28)

PWM_PIN  = 2
IN2_PIN  = 3
IN1_PIN  = 4
STBY_PIN = 5

btn_fwd  = Pin(FWD_PIN,  Pin.IN, Pin.PULL_DOWN)
btn_bwd  = Pin(BWD_PIN,  Pin.IN, Pin.PULL_DOWN)
btn_stop = Pin(STOP_PIN, Pin.IN, Pin.PULL_DOWN)

pot = ADC(POT_PIN)

in1  = Pin(IN1_PIN, Pin.OUT)
in2  = Pin(IN2_PIN, Pin.OUT)
stby = Pin(STBY_PIN, Pin.OUT)

pwm = PWM(Pin(PWM_PIN))
pwm.freq(1000)

state = 0

last_fwd  = 0
last_bwd  = 0
last_stop = 0

DEADBAND = 2000

def state_text(s):
    txt = ""
    if s == 0:
        txt = "STOP"
    if s == 1:
        txt = "FWD"
    if s == 2:
        txt = "BWD"
    return txt

last_print_ms = time.ticks_ms()
PRINT_EVERY_MS = 200  

while True:
    raw = pot.read_u16()
    volts = raw * 3.3 / 65535
    duty = raw
    if duty < DEADBAND:
        duty = 0

    f = btn_fwd.value()
    b = btn_bwd.value()
    s = btn_stop.value()

    fwd_edge = 0
    if last_fwd == 0 and f == 1:
        fwd_edge = 1

    bwd_edge = 0
    if last_bwd == 0 and b == 1:
        bwd_edge = 1

    stop_edge = 0
    if last_stop == 0 and s == 1:
        stop_edge = 1

    last_fwd = f
    last_bwd = b
    last_stop = s

    if state != 0 and duty == 0:
        state = 0

    if stop_edge == 1:
        state = 0

    if fwd_edge == 1:
        if duty > 0:
            if state == 0:
                state = 1

    if bwd_edge == 1:
        if duty > 0:
            if state == 0:
                state = 2
    
    if state == 0:
        stby.value(0); in1.value(0); in2.value(0); pwm.duty_u16(0)
    if state == 1:
        stby.value(1); in1.value(1); in2.value(0); pwm.duty_u16(duty)
    if state == 2:
        stby.value(1); in1.value(0); in2.value(1); pwm.duty_u16(duty)

    now = time.ticks_ms()
    if time.ticks_diff(now, last_print_ms) >= PRINT_EVERY_MS:
        print("Estado:", state_text(state),
              "| FWD:", f, "BWD:", b, "STOP:", s,
              "| RAW:", raw, "| V:", "{:.2f}".format(volts),
              "| DUTY:", duty)
        last_print_ms = now

    time.sleep_ms(10)