#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Wire.h>
// definicion de pines 
#define SDA D4
#define SCL D5
#define potY D1
#define potX D2

// Caracteristicas de la pantalla SSD1306
#define height 64
#define width 128 
#define rst    -1
// creación del objeto pantalla con la libreria SSD1306
Adafruit_SSD1306 display(width, height, &Wire, rst);
//Variables del proceso
int potValue = 0; // se inicializa en 0 para evitar lecturac sin valor.
unsigned int posX = 64-5, posY = 32-5; 
int centro[2] = {2222, 2159};//Valor inicial en ejes X=2222 & Y=2159 del JoyStick

void setup() {
  Serial.begin(115200);
  Wire.begin();
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0X3C)){
    Serial.println("Oled Display NOT Found...");
    for(;;);
  }
  displayTxtConfig(2, 15, 0);
  display.clearDisplay();
  display.println("PongBALL");
  displayTxtConfig(2, 40, 30);
  display.println("GAME");
  display.display();
  Serial.println("PongBALL GAME");
  delay(3000);
  
}

void loop() {
 //Leemos los valores de los potenciometros;
    int lectura[2];
    lectura[0] = analogRead(potX);
    lectura[1] = analogRead(potY);
    //Se evalua el cambio de posicion con un umbral de 100 en binbario
    if(lectura[0]-centro[0] > 100){posX += 1;}
    if(lectura[0]-centro[0] <-100){posX -= 1;}
    if(lectura[1]-centro[1] > 100){posY -= 1;}
    if(lectura[1]-centro[1] <-100){posY += 1;}

    //llamamos al metodo para dibujar el cuadrado en la posicion actual
     pintarCuadrado(posX, posY);
    //Se si el cuadrado sale de la pantalla se dibuja al otro lado
    if(posX>127)      {posX = 1;}
    if(posX<1)      {posX = 127;}
    if(posY>63)       {posY = 1;}
    if(posY<1)       {posY = 63;}
    Serial.print("LecturaX:");
    Serial.println(lectura[0]);
    Serial.print("LecturaY:");
    Serial.println(lectura[1]);

}
void displayTxtConfig(int size, int x, int y){
  //Pasos para imprimir
  //1. Seleccionar tamaño de la letra
  display.setTextSize(size);
  //2. Color de la letra(Blanco/Negro)
  display.setTextColor(WHITE);
  //3. posicionar el cursor
  display.setCursor(x, y);
}

void pintarCuadrado(int x, int y){
  display.clearDisplay();
  display.fillRect(x,y,10,10,WHITE);
  display.display();

}