#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Wire.h>
// definicion de pines 
#define SDA D4
#define SCL D5
#define POT D1
// Caracteristicas de la pantalla SSD1306
#define height 64
#define width 128 
#define rst    -1
// creación del objeto pantalla con la libreria SSD1306
Adafruit_SSD1306 display(width, height, &Wire, rst);
//Variables del proceso
int potValue = 0; // se inicializa en 0 para evitar lecturac sin valor.


void setup() {
  Serial.begin(115200);
  Wire.begin();
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0X3C)){
    Serial.println("Oled Display NOT Found...");
    for(;;);
  }
  displayTxtConfig(1, 0, 10);
  display.clearDisplay();
  display.println("Hello, XIAO ESP32-C3!");
  display.display();
  Serial.println("Hello, XIAO ESP32-C3!");
  delay(3000);
  
}

void loop() {
  //Lectura y reescalado de la señal del potenciometro
  potValue = analogRead(POT);
  potValue = map(potValue, 0, 4095, 0, 100);
  
  //Impresion del valor del potenciometro en el monitor Serial
  Serial.print("Potenciometer_Value:");
  Serial.print("\t");
  Serial.print(potValue);
  Serial.println();

  //Impresion del valor del potenciometro en pantalla OLED
  display.clearDisplay();
  displayTxtConfig(2, 0, 10);
  display.println("Pot_Value:");
  display.print(potValue);
  display.print("%");
  display.display();
  //espera para nueva lectura de 1/2 Seg  
  delay(500);
}
void displayTxtConfig(int size, int x, int y){
  
  //Pasos para imprimir
 
  //1. Seleccionar tamaño de la letra
  display.setTextSize(size);
  //2. Color de la letra(Blanco/Negro)
  display.setTextColor(WHITE);
  //3. posicionar el cursor
  display.setCursor(x, y);
}
