/*
  Blink

  Turns an LED on for one second, then off for one second, repeatedly.

  Most Arduinos have an on-board LED you can control. On the UNO, MEGA and ZERO
  it is attached to digital pin 13, on MKR1000 on pin 6. LED_BUILTIN is set to
  the correct LED pin independent of which board is used.
  If you want to know what pin the on-board LED is connected to on your Arduino
  model, check the Technical Specs of your board at:
  https://docs.arduino.cc/hardware/

  modified 8 May 2014
  by Scott Fitzgerald
  modified 2 Sep 2016
  by Arturo Guadalupi
  modified 8 Sep 2016
  by Colby Newman

  This example code is in the public domain.

  https://docs.arduino.cc/built-in-examples/basics/Blink/
*/
int LED_B = 15;
int dL = 1500;
int dS = 500;
int dM = 15;

// the setup function runs once when you press reset or power the board
void setup() {
  // initialize digital pin LED_BUILTIN as an output.
  pinMode(LED_B, OUTPUT);
  Serial.begin(115200);
 

}

// the loop function runs over and over again forever
void loop() {
Serial.println("Short Blinks!");
for (int i = 0; i < 2; i++) {  //2 short
  analogWrite(LED_B, 255);  // turn the LED on (HIGH is the voltage level)
  delay(dS);                      // wait for a second
  analogWrite(LED_B, 0);   // turn the LED off by making the voltage LOW
  delay(dS);                      // wait for a second
}
Serial.println("Long Blink!");
for (int i = 0; i < 2; i++) { // 2 long
    digitalWrite(LED_B, HIGH);   // ON
    delay(dL);
    digitalWrite(LED_B, LOW);  // OFF
    delay(dL);
  }
Serial.println("ESP32-C6 Fade!");
  // Fade ON (255=off, 0=bright)
for (int b = 255; b >= 0; b -= 5) {
    analogWrite(LED_B, b);
    delay(dM);
  }
  // Fade OFF
for (int b = 0; b <= 255; b += 5) {
    analogWrite(LED_B, b);
    delay(dM);
  }
  delay(dS);

if (Serial.available() > 0) {
    String input = Serial.readStringUntil('\n');
    Serial.print("You typed: ");
    Serial.println(input);
  }

}
