#include "Zigbee.h"

#define POTI_PIN 4
#define ZIGBEE_ENDPOINT 10

// My Calibration Values - when using different Sensor change to your min max values
int minValue = 0;
int maxValue = 3504;
bool calibrated = false;

// Smoothing Values
#define SMOOTHING_SAMPLES 10
int readings[SMOOTHING_SAMPLES];
int readIndex = 0;
int total = 0;

ZigbeeAnalog zbPoti = ZigbeeAnalog(ZIGBEE_ENDPOINT);

void setup() {
  Serial.begin(115200);
  delay(1000);
  
  // ADC
  analogReadResolution(12);
  analogSetAttenuation(ADC_11db);
  
  // Init Smoothing
  for (int i = 0; i < SMOOTHING_SAMPLES; i++) {
    readings[i] = 0;
  }
  
  // Zigbee config
  zbPoti.setManufacturerAndModel("ESP H2", "Rotation Sensor");
  zbPoti.addAnalogInput();
  zbPoti.setAnalogInputDescription("Rotation Sensor");
  zbPoti.setAnalogInputMinMax(0, 100);
  
  Zigbee.addEndpoint(&zbPoti);
  Zigbee.setRebootOpenNetwork(180);
  
  Serial.println("Starting Zigbee...");
  if (!Zigbee.begin(ZIGBEE_ROUTER, false)) {
    Serial.println("Zigbee failed!");
    ESP.restart();
  }
  
  Serial.println("Zigbee OK! Waiting for connection...");
}

void loop() {
  static unsigned long lastRead = 0;
  static int lastValue = -1;
  
  if (millis() - lastRead >= 100) {
    // Read ADC and Smooth Result
    int rawValue = analogRead(POTI_PIN);
    total = total - readings[readIndex];
    readings[readIndex] = rawValue;
    total = total + readings[readIndex];
    readIndex = (readIndex + 1) % SMOOTHING_SAMPLES;
    int smoothed = total / SMOOTHING_SAMPLES;
    
    // Remap to Percent (0-100)
    int mappedValue = map(smoothed, minValue, maxValue, 0, 100);
    mappedValue = constrain(mappedValue, 0, 100);
    
    // Just update when Value-Change > 2
    if (abs(mappedValue - lastValue) >= 2) {
      Serial.print("Poti: ");
      Serial.print(mappedValue);
      Serial.println("%");
      
      if (Zigbee.connected()) {
        zbPoti.setAnalogInput((float)mappedValue);
        zbPoti.reportAnalogInput();
      }
      
      lastValue = mappedValue;
    }
    
    lastRead = millis();
  }
  
  delay(10);
}
