#include <Arduino.h>
#include <Servo.h>
#include <Ultrasonic.h>

#define BUZZER_PIN 18
#define SERVO_PIN 16

Ultrasonic ultrasonic(20);
Servo servo;

void setup() {
    pinMode(BUZZER_PIN, OUTPUT);
    servo.attach(SERVO_PIN);
    Serial.begin(115200);
}

void loop() {
    long distance = ultrasonic.MeasureInCentimeters();
    Serial.println(distance);
    
    if (distance > 2 && distance < 400) {
        int frequency = map(distance, 2, 400, 2000, 200);
        tone(BUZZER_PIN, frequency);
        int angle = map(distance, 2, 400, 0, 180);
        servo.write(angle);
    } else {
        noTone(BUZZER_PIN);
    }
    delay(100);
}
