# Pico W Rust Blink Debug Session Summary

Date: 2026-02-16

## Goal
Create and upload a Rust firmware for Raspberry Pi Pico W to blink an LED on a Seeed Studio Grove Shield (LED socket on D16 / GPIO16).

## Hardware
- Board: Raspberry Pi Pico W (c)2022
- Shield: Seeed Studio Grove Shield for Pi Pico
- LED module connected to: D16 (maps to GPIO16)

## Symptoms
- Firmware uploaded, but LED stayed off.
- PlatformIO C++ project worked reliably with `OUTPUT_PORT = 16`.

## Key Root Cause
The Rust ELF linker layout was wrong for RP2040 boot:
- `.boot2` was not at `0x10000000`.
- Result: image could be flashed but not reliably boot/executed.

After fixing linker placement, firmware started running correctly.

## What Was Changed
Project path:
- `pico-bsp-path`

### 1. Added RP2040 linker fragment
File:
- `link-rp.x`

Purpose:
- Force `.boot2` section into BOOT2 memory region at `0x10000000`.

### 2. Updated build script
File:
- `build.rs`

Change:
- Copies both `memory.x` and `link-rp.x` into Cargo `OUT_DIR` and exposes them to linker.

### 3. Updated Cargo target flags
File:
- `.cargo/config.toml`

Change:
- Added linker arg:
  - `-C link-arg=-Tlink-rp.x`

### 4. Simplified final firmware to minimal stable blink
File:
- `src/bin/grove_d16.rs`

Behavior:
- Configure GPIO16 as push-pull output.
- Blink loop: 500 ms ON, 500 ms OFF.

### 5. Added upload helper script
File:
- `upload.sh`

Behavior:
- Build release binary offline.
- Convert ELF to UF2.
- Attempt optional 1200-bps reset on `/dev/ttyS0` (or `PICO_TTY_PORT`).
- Upload via PlatformIO `picotool`.
- Fallback: direct UF2 copy if BOOTSEL mass-storage mount exists.

## Verification Performed
- Confirmed section layout in final ELF includes:
  - `.boot2` at `0x10000000`
- Successful user confirmation: LED started blinking.

## Final Usage
From project directory:

```bash
cd pico-bsp-path
./upload.sh grove_d16
```

Optional custom serial port:

```bash
PICO_TTY_PORT=/dev/ttyS0 ./upload.sh grove_d16
```

## Notes
- On Pico W, internal LED control differs from non-W Pico; external D16/GPIO16 path is straightforward and now stable.
- If upload tool cannot find device, enter BOOTSEL mode manually and rerun.
