# Pico W Grove D16 Blink (Rust) Quickstart

Project:
- `pico-bsp-path`

## Hardware
- Raspberry Pi Pico W
- Seeed Grove Shield for Pi Pico
- Grove LED socket on D16 (GPIO16)

## One-command build + upload

```bash
cd pico-bsp-path
./upload.sh grove_d16
```

## If your serial/reset port is different

```bash
cd pico-bsp-path
PICO_TTY_PORT=/dev/ttyS0 ./upload.sh grove_d16
```

## If upload cannot find the board
1. Hold BOOTSEL while plugging in USB.
2. Re-run:

```bash
./upload.sh grove_d16
```

## What this firmware does
- Drives `GPIO16` as push-pull output.
- Blinks LED: `500ms ON`, `500ms OFF`.

Source file:
- `src/bin/grove_d16.rs`
