#![no_std]
#![no_main]

use embedded_hal::blocking::delay::DelayMs;
use embedded_hal::digital::v2::OutputPin;
use panic_halt as _;

#[path = "../board.rs"]
mod board;

#[rp2040_hal::entry]
fn main() -> ! {
    let mut b = board::init();
    let mut led = b.pins.gpio16.into_push_pull_output();

//    const ON_MS: u32 = 500;
//    const OFF_MS: u32 = 500;
    const ON_MS: u32 = 1500;
    const OFF_MS: u32 = 1500;

    loop {
        led.set_high().ok();
        b.timer.delay_ms(ON_MS);
        led.set_low().ok();
        b.timer.delay_ms(OFF_MS);
    }
}
