#![no_std]
#![no_main]

use embedded_hal::blocking::delay::DelayMs;
use embedded_hal::digital::v2::OutputPin;
use panic_halt as _;

#[path = "../board.rs"]
mod board;

#[rp2040_hal::entry]
fn main() -> ! {
    let mut b = board::init();

    let mut led = b.pins.gpio25.into_push_pull_output();
    loop {
        led.set_high().ok();
        //b.timer.delay_ms(500u32);
        b.timer.delay_ms(100u32);
        led.set_low().ok();
        //b.timer.delay_ms(500u32);
        b.timer.delay_ms(100u32);
    }
}
