#include "ClockHand.h"
#include "ClockFace.h"
#include "Clock.h"

#include "SafeStringReader.h"

#include <ArduinoBLE.h>

// Global Setup for Clock
ClockFace face = ClockFace({{"home", 22}, {"peril", 67}, {"transit", 112}, {"lost", 157}, 
                            {"work", 202}, {"prison", 247}, {"shopping", 292},{"holidays", 337}});
std::vector<ClockHand> hands =   
{
    ClockHand ("h1", MOTOR_28BYJ_48, ClockHand::ANTI_CLOCKWISE,2, 4, 3, 5),
    ClockHand ("h2", MOTOR_28BYJ_48, ClockHand::ANTI_CLOCKWISE, 6, 8, 7, 9),
    ClockHand ("h3", MOTOR_28BYJ_48, ClockHand::CLOCKWISE, 10, 12, 11, 13),
    ClockHand ("h4", MOTOR_28BYJ_48, ClockHand::ANTI_CLOCKWISE, A0, A2, A1, A3)
};
Clock theClock = Clock(face, hands);

// Global Setup for Safe String 
createSafeStringReader(sfReader,50,"\r\n");

// Global Setup for Arduino BLE
BLEService clockService("19B10000-E8F2-537E-4F6C-D104768A1214"); // create service
BLEStringCharacteristic clockCharacteristic("19B10001-E8F2-537E-4F6C-D104768A1214", BLERead | BLEWrite, 20);

void setup() {
  setupSerialMonitor();
  setupBLE();
  setupSafeString();
  theClock.setIO(Serial);
}

void loop() {
  // Non-Blocking Safe String Read
  if (sfReader.read())
  {
    sfReader.trim();
    theClock.set(sfReader.c_str());
  }
  
  BLE.poll();
  theClock.tick();
}

void setupSerialMonitor () {
  // Serial Monitor Setup
  for (int timer = 0; timer < 1000; timer++)
  {
    if (Serial)
    {
      Serial.begin(9600);
      delay(1000);
      Serial.println();
      Serial.println("Arduino Serial Monitor started...");
      break;
    }
    delay(10);
  }
}

void setupBLE () {
  for (int timer = 0; timer < 1000; timer++)
  {
    if (BLE.begin())
    {
      Serial.println("Arduino BLE started...");
      BLE.setLocalName("Clock");
      clockService.addCharacteristic(clockCharacteristic);
      clockCharacteristic.setValue("Test");
      BLE.setEventHandler(BLEConnected, bleConnectHandler);
      BLE.setEventHandler(BLEDisconnected, blePeripheralDisconnectHandler);
      clockCharacteristic.setEventHandler(BLEWritten, clockCharacteristicWritten);
      BLE.addService(clockService);
      BLE.setAdvertisedService(clockService);
      BLE.advertise();
      Serial.println("Bluetooth® device active, waiting for connections...");
      return;
    }
    delay(10);
  }
}

void setupSafeString () {
  SafeString::setOutput(Serial);
  sfReader.setTimeout(1000);
  sfReader.flushInput();
  sfReader.echoOn();
  sfReader.connect(Serial);
}

void bleConnectHandler(BLEDevice central) {
  // central connected event handler
  BLE.stopAdvertise();
  Serial.print("Connection made with central device: ");
  Serial.println(central.address());
}

void blePeripheralDisconnectHandler(BLEDevice central) {
  // central disconnected event handler
  Serial.print("Disconnected from central device: ");
  Serial.println(central.address());
  BLE.advertise();
}

void clockCharacteristicWritten(BLEDevice central, BLECharacteristic characteristic) {
  // central wrote new value to characteristic, update clock
  Serial.print("Clock characteristic written: ");
  Serial.println(clockCharacteristic.value());
  theClock.set(clockCharacteristic.value().c_str());
}



