#ifndef ClockHand_H
#define ClockHand_H

#include <AccelStepper.h>
#include "ClockMotor.h"

class ClockHand : public AccelStepper
{
  public:
    using AccelStepper::AccelStepper;
    static const bool CLOCKWISE = true;
    static const bool ANTI_CLOCKWISE = false;
    ClockHand(std::string name, motor_t motor, bool motorOrientation, uint8_t pin1, uint8_t pin2, uint8_t pin3, uint8_t pin4);
    std::string name;
    void moveTo(long positionInSteps);
    void moveToDegree(int positionInDegrees);
    void calibrate (Stream& io);    

  private:
    bool _motorOrientation;
    motor_t _motor;
};

#endif