#include "ClockFace.h"

//ClockFace::ClockFace ()
//{
//
//}

ClockFace::ClockFace (std::vector<ClockFacePosition> positions)
{
  _cfp = positions;
  std::srand(std::time({})); // use current time as seed for random generator
}

int ClockFace::getPosition(std::string name)
{
  for (ClockFacePosition pos : _cfp)
  {
    if (pos.name == name)
    {
       return pos.degree;
    }
  }
  return -1;
}

int ClockFace::getPositionRandom()
{
  int numFacePositions = _cfp.size();
  if (numFacePositions == 0)
  {
    return rand() % 361;
  }
  else
  {
    int position = rand() % numFacePositions;
    return _cfp[position].degree;
  }
}

void ClockFace::print_positions()
{
  Serial.print(_cfp.size());
  Serial.println(" Clock Face Positions");
  for (ClockFacePosition pos : _cfp)
  {
    Serial.print(pos.name.c_str());
    Serial.print(" ");
    Serial.println(pos.degree);
  }
}

