#ifndef CLOCK_H
#define CLOCK_H

#include <vector>
#include <sstream>
#include "ClockFace.h"
#include "ClockHand.h"

class Clock 
{
  public:
    Clock(ClockFace&, std::vector<ClockHand>&);
    void tick ();
    void set (std::string);
    void set (std::string, std::string);
    void setIO (Stream& io);
    void calibrate ();
    void calibrate (Stream& io);    

  private:
    ClockFace& _face;
    std::vector<ClockHand>& _hands;
    Stream* _io;
    void manage (std::string);
    void randomize ();
    void facelift ();
};

#endif