#include "Clock.h"

Clock::Clock(ClockFace& face, std::vector<ClockHand>& hands) : _face(face), _hands(hands)
{
   _io = nullptr;
}

void Clock::set(std::string handAndPosition)
{
  std::string cmd = handAndPosition;
  std::istringstream sstream(cmd);
  std::string token;
  std::vector<std::string> tokens;
  while (std::getline(sstream, token, ':'))
  {
    tokens.push_back(token);
  }
  if (tokens.size() > 1)
  {
    this->set(tokens[0],tokens[1]);
  }
}

void Clock::set(std::string handName, std::string toPosition)
{
  if (handName == "clock")
  {
    this->manage(toPosition);
  }
  else
  {
    for (size_t i = 0; i < _hands.size(); ++i)
    {
      if (_hands[i].name == handName)
      {
        _hands[i].moveToDegree(_face.getPosition(toPosition));
      }
    }
  }
}

void Clock::tick()
{
  for (size_t i = 0; i < _hands.size(); ++i)
  {
    _hands[i].run();
  }
}

void Clock::setIO(Stream &io)
{
  _io = &io;
}

void Clock::manage (std::string operation)
{
  if (operation == "calibrate")
  {
    this->calibrate();
  }
  else if (operation == "facelift")
  {
    this->facelift();
  }
  else if (operation == "randomize")
  {
    this->randomize();
  }  
}

void Clock::calibrate ()
{
  if (_io != nullptr)
  {
    for (size_t i = 0; i < _hands.size(); ++i)
    {
      _hands[i].calibrate(*_io);
    }
  }
}

void Clock::calibrate (Stream& io)
{
  for (size_t i = 0; i < _hands.size(); ++i)
  {
    _hands[i].calibrate(io);
  }
}

void Clock::facelift ()
{
  for (size_t i = 0; i < _hands.size(); ++i)
  {
     _hands[i].moveToDegree(90);
  }
}

void Clock::randomize ()
{
  for (size_t i = 0; i < _hands.size(); ++i)
  {
     _hands[i].moveToDegree(_face.getPositionRandom());
  }
}
