// ======================================================
//  Locus Pocus Secondary - Clock Device / Motor Control
// ======================================================
/* 

ClockHand.h - 
Class representing Locus Pocus clock hand as part of the clock device, 
providing for setup and management of a clock hand and associated 
movement driven by a stepper motor in response to clock commands.  

Copyright (C) 2025 - David Wilson

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef ClockHand_H
#define ClockHand_H

#include <AccelStepper.h>
#include "ClockMotor.h"

class ClockHand : public AccelStepper
{
  public:
    using AccelStepper::AccelStepper;
    static const bool CLOCKWISE = true;
    static const bool ANTI_CLOCKWISE = false;
    ClockHand(std::string name, motor_t motor, bool motorOrientation, uint8_t pin1, uint8_t pin2, uint8_t pin3, uint8_t pin4);
    std::string name;
    void moveTo(long positionInSteps);
    void moveToDegree(int positionInDegrees);
    void calibrate (Stream& io);    

  private:
    bool _motorOrientation;
    motor_t _motor;
};

#endif