// ======================================================
//  Locus Pocus Secondary - Clock Device / Motor Control
// ======================================================
/* 

ClockFace.h - 
Class representing Locus Pocus clock face as part of the clock device, 
providing for setup and management of a clock face with designated 
semantic positions.  

Copyright (C) 2025 - David Wilson

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef CLOCK_FACE_H
#define CLOCK_FACE_H

#include <vector>
#include <string>
#include <cstdlib>
#include <ctime>
#include "Arduino.h"


struct ClockFacePosition 
{
  std::string name;
  int degree;
};

class ClockFace
{
  public:
//    ClockFace ();
    ClockFace (std::vector<ClockFacePosition>);
    void print_positions ();
    int getPosition(std::string name);
    int getPositionRandom();

  private:
    std::vector<ClockFacePosition> _cfp;  
};


#endif