// ======================================================
//  Locus Pocus Secondary - Clock Device / Motor Control
// ======================================================
/* 

ClockFace.cpp - 
Class representing Locus Pocus clock face as part of the clock device, 
providing for setup and management of a clock face with designated 
semantic positions.  

Copyright (C) 2025 - David Wilson

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#include "ClockFace.h"

//ClockFace::ClockFace ()
//{
//
//}

ClockFace::ClockFace (std::vector<ClockFacePosition> positions)
{
  _cfp = positions;
  std::srand(std::time({})); // use current time as seed for random generator
}

int ClockFace::getPosition(std::string name)
{
  for (ClockFacePosition pos : _cfp)
  {
    if (pos.name == name)
    {
       return pos.degree;
    }
  }
  return -1;
}

int ClockFace::getPositionRandom()
{
  int numFacePositions = _cfp.size();
  if (numFacePositions == 0)
  {
    return rand() % 361;
  }
  else
  {
    int position = rand() % numFacePositions;
    return _cfp[position].degree;
  }
}

void ClockFace::print_positions()
{
  Serial.print(_cfp.size());
  Serial.println(" Clock Face Positions");
  for (ClockFacePosition pos : _cfp)
  {
    Serial.print(pos.name.c_str());
    Serial.print(" ");
    Serial.println(pos.degree);
  }
}

