// ======================================================
//  Locus Pocus Secondary - Clock Device / Motor Control
// ======================================================
/* 

Clock.h - 
Class representing Locus Pocus clock device, providing for setup of clock
device components (face, hands, motor), and translating clock commands into
motor control for clock hand actions.

Copyright (C) 2025 - David Wilson

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#ifndef CLOCK_H
#define CLOCK_H

#include <vector>
#include <sstream>
#include "ClockFace.h"
#include "ClockHand.h"

class Clock 
{
  public:
    Clock(ClockFace&, std::vector<ClockHand>&);
    void tick ();
    void set (std::string);
    void set (std::string, std::string);
    void setIO (Stream& io);
    void calibrate ();
    void calibrate (Stream& io);    

  private:
    ClockFace& _face;
    std::vector<ClockHand>& _hands;
    Stream* _io;
    void manage (std::string);
    void randomize ();
    void facelift ();
};

#endif