// ======================================================
//  Locus Pocus Secondary - Clock Device / Motor Control
// ======================================================
/* 

Clock.cpp - 
Class representing Locus Pocus clock device, providing for setup of clock
device components (face, hands, motor), and translating clock commands into
motor control for clock hand actions.

Copyright (C) 2025 - David Wilson

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

#include "Clock.h"

Clock::Clock(ClockFace& face, std::vector<ClockHand>& hands) : _face(face), _hands(hands)
{
   _io = nullptr;
}

void Clock::set(std::string handAndPosition)
{
  std::string cmd = handAndPosition;
  std::istringstream sstream(cmd);
  std::string token;
  std::vector<std::string> tokens;
  while (std::getline(sstream, token, ':'))
  {
    tokens.push_back(token);
  }
  if (tokens.size() > 1)
  {
    this->set(tokens[0],tokens[1]);
  }
}

void Clock::set(std::string handName, std::string toPosition)
{
  if (handName == "clock")
  {
    this->manage(toPosition);
  }
  else
  {
    for (size_t i = 0; i < _hands.size(); ++i)
    {
      if (_hands[i].name == handName)
      {
        _hands[i].moveToDegree(_face.getPosition(toPosition));
      }
    }
  }
}

void Clock::tick()
{
  for (size_t i = 0; i < _hands.size(); ++i)
  {
    _hands[i].run();
  }
}

void Clock::setIO(Stream &io)
{
  _io = &io;
}

void Clock::manage (std::string operation)
{
  if (operation == "calibrate")
  {
    this->calibrate();
  }
  else if (operation == "facelift")
  {
    this->facelift();
  }
  else if (operation == "randomize")
  {
    this->randomize();
  }  
}

void Clock::calibrate ()
{
  if (_io != nullptr)
  {
    for (size_t i = 0; i < _hands.size(); ++i)
    {
      _hands[i].calibrate(*_io);
    }
  }
}

void Clock::calibrate (Stream& io)
{
  for (size_t i = 0; i < _hands.size(); ++i)
  {
    _hands[i].calibrate(io);
  }
}

void Clock::facelift ()
{
  for (size_t i = 0; i < _hands.size(); ++i)
  {
     _hands[i].moveToDegree(90);
  }
}

void Clock::randomize ()
{
  for (size_t i = 0; i < _hands.size(); ++i)
  {
     _hands[i].moveToDegree(_face.getPositionRandom());
  }
}
