#include <Wire.h>
#include <Adafruit_MPU6050.h>
#include <Adafruit_Sensor.h>

Adafruit_MPU6050 mpu;

// Define motor control pins
const int motor1Pin = 3; // Adjust as per your wiring
const int motor2Pin = 5;
const int motor3Pin = 6;
const int motor4Pin = 9;

void setup() {
  Serial.begin(115200);
  while (!Serial)
    delay(10); // Wait for Serial to initialize

  // Initialize MPU6050
  if (!mpu.begin()) {
    Serial.println("Failed to find MPU6050 chip");
    while (1) {
      delay(10);
    }
  }
  Serial.println("MPU6050 Found!");

  // Set up motor control pins
  pinMode(motor1Pin, OUTPUT);
  pinMode(motor2Pin, OUTPUT);
  pinMode(motor3Pin, OUTPUT);
  pinMode(motor4Pin, OUTPUT);
}

void loop() {
  // Get new sensor events
  sensors_event_t a, g, temp;
  mpu.getEvent(&a, &g, &temp);
  analogwrite(motorpin4,100);
  

  // Placeholder for PID control logic
  // Use 'a' and 'g' data to compute motor speeds

  // Example: Set all motors to a fixed speed (for testing)
  analogWrite(motor1Pin, 128); // PWM value between 0-255
  analogWrite(motor2Pin, 128);
  analogWrite(motor3Pin, 128);
  analogWrite(motor4Pin, 128);

  delay(100);
}
