#include <WiFi.h>
#include <WebServer.h>

// Replace with your network credentials
const char* ssid = "EngineeringStudent";
const char* password = "cls2024!";

// Define pins for rows (cathodes) and columns (anodes)
const int rows[4] = {D0, D1, D2, D3};
const int cols[4] = {D7, D8, D9, D10};

// Current LED state
int activeRow = -1;
int activeCol = -1;
bool allOn = false;

// Web server on port 80
WebServer server(80);

void setupMatrixPins() {
  for (int i = 0; i < 4; i++) {
    pinMode(rows[i], OUTPUT);
    pinMode(cols[i], OUTPUT);
    digitalWrite(rows[i], HIGH);  // Rows HIGH = OFF
    digitalWrite(cols[i], LOW);   // Columns LOW = OFF
  }
}

void clearMatrix() {
  for (int i = 0; i < 4; i++) {
    digitalWrite(rows[i], HIGH);
    digitalWrite(cols[i], LOW);
  }
  activeRow = -1;
  activeCol = -1;
}

void lightLED(int row, int col) {
  clearMatrix();
  digitalWrite(cols[col], HIGH);
  digitalWrite(rows[row], LOW);
  activeRow = row;
  activeCol = col;
}

void lightAll() {
  clearMatrix();
  for (int r = 0; r < 4; r++) {
    for (int c = 0; c < 4; c++) {
      digitalWrite(cols[c], HIGH);
      digitalWrite(rows[r], LOW);
      delay(1);  // brief delay to allow all LEDs to blink visibly
      digitalWrite(cols[c], LOW);
      digitalWrite(rows[r], HIGH);
    }
  }
  allOn = true;
}

void handleRoot() {
  String html = R"rawliteral(
    <!DOCTYPE html><html><head>
    <style>
      body { font-family: Arial; text-align: center; }
      .grid { display: grid; grid-template-columns: repeat(4, 60px); gap: 10px; justify-content: center; margin-top: 20px; }
      .btn { width: 60px; height: 60px; background-color: red; border: none; color: white; font-size: 20px; }
      .btn.active { background-color: green; }
      .control { margin: 20px; }
    </style>
    <script>
      function send(x, y) {
        fetch('/press?row=' + x + '&col=' + y).then(() => location.reload());
      }
      function control(action) {
        fetch('/control?action=' + action).then(() => location.reload());
      }
    </script></head><body>
    <h1>4x4 LED Matrix Controller</h1>
    <div class="control">
      <button onclick="control('on')">Turn All On</button>
      <button onclick="control('off')">Turn All Off</button>
    </div>
    <div class="grid">
  )rawliteral";

  for (int r = 0; r < 4; r++) {
    for (int c = 0; c < 4; c++) {
      bool isActive = (r == activeRow && c == activeCol);
      html += "<button class='btn" + String(isActive ? " active" : "") + "' onclick='send(" + r + "," + c + ")'></button>";
    }
  }

  html += R"rawliteral(
    </div></body></html>
  )rawliteral";

  server.send(200, "text/html", html);
}

void handlePress() {
  if (server.hasArg("row") && server.hasArg("col")) {
    int row = server.arg("row").toInt();
    int col = server.arg("col").toInt();
    lightLED(row, col);
    allOn = false;
  }
  server.sendHeader("Location", "/");
  server.send(303);
}

void handleControl() {
  if (server.hasArg("action")) {
    String action = server.arg("action");
    if (action == "on") {
      lightAll();
    } else if (action == "off") {
      clearMatrix();
      allOn = false;
    }
  }
  server.sendHeader("Location", "/");
  server.send(303);
}

void setup() {
  Serial.begin(115200);
  setupMatrixPins();

  WiFi.begin(ssid, password);
  Serial.print("Connecting to WiFi");
  while (WiFi.status() != WL_CONNECTED) {
    delay(500); Serial.print(".");
  }
  Serial.println(" connected!");
  Serial.println(WiFi.localIP());

  server.on("/", handleRoot);
  server.on("/press", handlePress);
  server.on("/control", handleControl);
  server.begin();
}

void loop() {
  server.handleClient();

  // Keep "all on" visually blinking
  if (allOn) {
    lightAll();
  }
}
