// Define pins for rows and columns
const int rows[4] = {D0, D1, D2, D3};     // Row pins (cathode)
const int cols[4] = {D7, D8, D9, D10};    // Column pins (anode)

void setup() {
  // Set all row and column pins as OUTPUT
  for (int i = 0; i < 4; i++) {
    pinMode(rows[i], OUTPUT);
    pinMode(cols[i], OUTPUT);
    
    digitalWrite(rows[i], HIGH);   // Rows HIGH = OFF (since cathode)
    digitalWrite(cols[i], LOW);    // Columns LOW = OFF (since anode)
  }
}

void loop() {
  // Loop through all 16 LEDs
  for (int r = 0; r < 4; r++) {
    for (int c = 0; c < 4; c++) {
      lightLED(r, c);
      delay(200);
      clearMatrix();
    }
  }
}

// Function to light a single LED at (row, col)
void lightLED(int row, int col) {
  digitalWrite(cols[col], HIGH);  // Anode side ON
  digitalWrite(rows[row], LOW);   // Cathode side ON
}

// Turn off all LEDs
void clearMatrix() {
  for (int i = 0; i < 4; i++) {
    digitalWrite(cols[i], LOW);   // Anode side OFF
    digitalWrite(rows[i], HIGH);  // Cathode side OFF
  }
}
